<?php
// info.php — diagnóstico rápido
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h2>Diagnóstico do ambiente</h2>";
echo "<p><strong>__FILE__:</strong> " . __FILE__ . "</p>";
echo "<p><strong>__DIR__:</strong> " . __DIR__ . "</p>";
echo "<p><strong>DOCUMENT_ROOT:</strong> " . ($_SERVER['DOCUMENT_ROOT'] ?? '') . "</p>";
echo "<p><strong>REQUEST_URI:</strong> " . ($_SERVER['REQUEST_URI'] ?? '') . "</p>";
echo "<p><strong>SCRIPT_NAME:</strong> " . ($_SERVER['SCRIPT_NAME'] ?? '') . "</p>";

echo "<h3>Conteúdo da pasta atual:</h3><ul>";
foreach (scandir(__DIR__) as $f) {
  echo "<li>" . htmlspecialchars($f) . "</li>";
}
echo "</ul>";

if (file_exists(__DIR__ . '/index.php')) {
  echo "<p style='color:green'>index.php encontrado nesta pasta.</p>";
} else {
  echo "<p style='color:red'>index.php NÃO encontrado nesta pasta.</p>";
}
