<?php

class Relatorio {
    private $pdo;

    public function __construct() {
        try {
            $this->pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
            $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            die("Erro na conexão com o banco de dados: " . $e->getMessage());
        }
    }

    public function getTotalEleitores() {
        $stmt = $this->pdo->query("SELECT COUNT(*) as total FROM eleitores");
        return $stmt->fetchColumn();
    }

    public function getContagemPorSexo() {
        try {
            $stmt = $this->pdo->query("SELECT sexo, COUNT(*) as quantidade FROM eleitores WHERE sexo IS NOT NULL AND sexo != '' GROUP BY sexo");
            return $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
        } catch (PDOException $e) {
            echo "Erro: " . $e->getMessage();
        }
    }

    public function getContagemPorBairro() {
        $stmt = $this->pdo->query("SELECT bairro, COUNT(*) as quantidade FROM eleitores WHERE bairro IS NOT NULL AND bairro != '' GROUP BY bairro ORDER BY quantidade DESC LIMIT 10");
        return $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
    }

    public function getContagemPorTipo() {
        $stmt = $this->pdo->query("SELECT tipo, COUNT(*) as quantidade FROM eleitores GROUP BY tipo");
        return $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
    }

    public function getContagemPorDemanda() {
        // CORRIGIDO: A consulta agora usa a tabela 'agendas' em vez de 'demandas'.
        $stmt = $this->pdo->query("SELECT categoria, COUNT(*) as quantidade FROM agendas GROUP BY categoria ORDER BY quantidade DESC");
        return $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
    }

    public function getEleitoresRecentes() {
        $stmt = $this->pdo->query("SELECT nome_completo, email, data_cadastro FROM eleitores ORDER BY data_cadastro DESC LIMIT 5");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
