<?php
// src/views/partials/header.php
if (!defined('APP_BOOTSTRAP')) { define('APP_BOOTSTRAP', true); }

/**
 * BASE robusto:
 * - Usa BASE_URL se definido pelo front-controller
 * - Senão, deduz a partir do SCRIPT_NAME (ex.: /gabinete)
 */
$BASE = defined('BASE_URL')
  ? rtrim(BASE_URL, '/')
  : rtrim(dirname($_SERVER['SCRIPT_NAME'] ?? ''), '/');
if ($BASE === '' || $BASE === '.') { $BASE = ''; } // raiz
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?= $pageTitle ?? 'Gabinete' ?></title>

  <!-- Ícones Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

  <!-- Tailwind CSS (assumindo que você tem um build ou CDN ) -->
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">

  <!-- CSS do projeto (ok se não existir ) -->
  <link rel="stylesheet" href="<?= $BASE ?>/public/css/styles.css">

  <style>
    :root { --header-bg:#1f2937; }
    body{background:#f9fafb;margin:0; font-family: 'Inter', sans-serif;}
    .main-header{
      position:relative; z-index: 1000; /* fica acima de overlays acidentais */
      display:flex; align-items:center; gap:16px;
      padding:0 1rem; background:var(--header-bg); color:#fff;
      box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .logo{display:flex;align-items:center;gap:10px;text-decoration:none;color:#fff;font-weight:700;white-space:nowrap; font-size: 1.5rem;}
    .main-nav{flex:1}
    .main-nav ul{list-style:none;display:flex;gap:8px;margin:0;padding:0;flex-wrap:nowrap;overflow-x:auto;scrollbar-width:none;-ms-overflow-style:none}
    .main-nav ul::-webkit-scrollbar{display:none}
    .main-nav li{display:flex}
    .main-nav li a{
      display:inline-flex; align-items:center; gap:8px;
      padding:10px 12px; border-radius:8px; text-decoration:none; color:#fff; white-space:nowrap;
      pointer-events:auto; /* garante clique mesmo se algum pai tiver pointer-events:none */
      transition: background-color 0.2s ease;
    }
    .main-nav li a:hover{background:rgba(255,255,255,.15)}
    .main-nav li.push-right{margin-left:auto}
    /* Ajuste para o tamanho dos ícones Font Awesome */
    .main-nav li a i.fa, .main-nav li a svg {
        font-size: 1.1rem; /* Tamanho padrão para ícones de navegação */
        width: 1.1rem; /* Garante largura consistente */
        height: 1.1rem; /* Garante altura consistente */
        vertical-align: middle; /* Alinha com o texto */
    }
    /* Caso exista algum overlay global indevido, neutraliza cliques sobre ele */
    .app-overlay, .overlay, .modal-backdrop {
      pointer-events:none !important;
    }
    @media (max-width: 768px){
      .main-header{padding:0 .75rem; flex-wrap: wrap; justify-content: center;}
      .logo { width: 100%; text-align: center; justify-content: center; margin-bottom: 10px;}
      .main-nav { width: 100%; }
      .main-nav ul { justify-content: center; }
      .main-nav li a{padding:8px 10px; font-size: 0.9rem;}
      .main-nav li a i.fa, .main-nav li a svg { font-size: 1rem; width: 1rem; height: 1rem; }
      .main-nav li.push-right{margin-left:0;}
    }
  </style>
</head>
<body>
<header class="main-header" role="banner">
  <a href="<?= $BASE ?>/" class="logo"><span>Gabinete</span></a>
  <nav class="main-nav" role="navigation" aria-label="Menu principal">
    <?php if (!empty($_SESSION['logado'])): ?>
      <ul>
        <li><a href="<?= $BASE ?>/"><i class="fa fa-calendar-alt"></i><span>Agenda</span></a></li>
        <li><a href="<?= $BASE ?>/documentos"><i class="fa fa-file-alt"></i><span>Documentos</span></a></li>
        <li><a href="<?= $BASE ?>/eleitores"><i class="fa fa-users"></i><span>Eleitores</span></a></li>

        <!-- RH -> ROTA /employees (controller index renderiza src/views/employees/index.php) -->
        <li><a href="<?= $BASE ?>/employees"><i class="fa fa-id-badge"></i><span>RH</span></a></li>

        <li><a href="<?= $BASE ?>/relatorios"><i class="fa fa-chart-pie"></i><span>Relatórios</span></a></li>
        <li><a href="<?= $BASE ?>/contas/contas.php"><i class="fa fa-coins"></i><span>Financeiro</span></a></li>

        <?php if (isset($_SESSION['usuario_nivel_acesso']) && $_SESSION['usuario_nivel_acesso'] === 'Admin'): ?>
          <li><a href="<?= $BASE ?>/paineladmin"><i class="fa fa-user-shield"></i><span>PainelAdmin</span></a></li>
        <?php endif; ?>

        <li class="push-right"><a href="<?= $BASE ?>/configuracoes"><i class="fa fa-cog"></i><span>Configurações</span></a></li>
        <li><a href="<?= $BASE ?>/usuario/logout"><i class="fa fa-sign-out-alt"></i><span>Sair</span></a></li>
      </ul>
    <?php else: ?>
      <ul>
        <li><a href="<?= $BASE ?>/usuario/login"><i class="fa fa-sign-in-alt"></i><span>Login</span></a></li>
      </ul>
    <?php endif; ?>
  </nav>
</header>

<main>

<!-- Failsafe JS: se algum script impedir a navegação (preventDefault), forçamos a troca de página -->
<script>
(function(){
  // Mostra no código-fonte qual header está ativo (útil pra checar se é este arquivo)
  try { document.write("<!-- HEADER ATIVO: " + <?= json_encode(__FILE__) ?> + " -->"); } catch(e){}
  // Força navegação se algum script impedir o clique
  document.querySelectorAll('.main-nav a[href]').forEach(function(a){
    a.addEventListener('click', function(e){
      var href = a.getAttribute('href');
      if (!href || href === '#') { e.preventDefault(); return; }
      // se algum outro listener chamou preventDefault, ainda navegamos:
      if (e.defaultPrevented) { window.location.assign(href); }
      // fallback: se 150ms após o clique a URL não mudou, forçamos:
      var prev = window.location.href;
      setTimeout(function(){
        if (window.location.href === prev) { window.location.assign(href); }
      }, 150);
    }, true); // fase de captura: roda antes de 'return false' em handlers antigos
  });
})();
</script>
