<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

<style>
    /* Estilos adaptados do seu arquivo relatorio.php */
    .dashboard { display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px; }
    .card { background: white; border-radius: 8px; padding: 20px; box-shadow: 0 4px 12px rgba(0,0,0,0.08); }
    .card h3 { text-align: center; margin-bottom: 20px; color: #34495e; }
    .stat-number { font-size: 3em; font-weight: bold; color: #3498db; text-align: center; }
    .chart-container { position: relative; height: 320px; width: 100%; }
    .full-width { grid-column: 1 / -1; }
    .btn-pdf-container { text-align: center; margin: 30px 0; }
    .btn-pdf { background: #e74c3c; color: white; border: none; padding: 12px 25px; border-radius: 5px; cursor: pointer; font-size: 1.1em; transition: background 0.3s; }
    .btn-pdf:hover { background: #c0392b; }
</style>

<div class="content-box" id="report-container">
    <header style="text-align: center; margin-bottom: 30px;">
        <h1>Relatórios e Estatísticas</h1>
        <p>Dashboard com dados de Eleitores e Demandas</p>
    </header>

    <div class="dashboard">
        <div class="card">
            <h3>Total de Eleitores</h3>
            <div class="stat-number"><?= $dados['totalEleitores']; ?></div>
        </div>

        <div class="card">
            <h3>Distribuição por Sexo</h3>
            <div class="chart-container">
                <canvas id="sexoChart"></canvas>
            </div>
        </div>

        <div class="card">
            <h3>Apoiador vs. Liderança</h3>
            <div class="chart-container">
                <canvas id="tipoChart"></canvas>
            </div>
        </div>

        <div class="card full-width">
            <h3>Top 10 Bairros com Mais Apoio</h3>
            <div class="chart-container">
                <canvas id="bairroChart"></canvas>
            </div>
        </div>

        <div class="card full-width">
            <h3>Demandas Mais Solicitadas</h3>
            <div class="chart-container">
                <canvas id="demandaChart"></canvas>
            </div>
        </div>
        
        <div class="card full-width">
            <h3>Últimos 5 Eleitores Cadastrados</h3>
            <table>
                <thead><tr><th>Nome</th><th>Email</th><th>Data de Cadastro</th></tr></thead>
                <tbody>
                    <?php foreach ($dados['eleitoresRecentes'] as $eleitor): ?>
                    <tr>
                        <td><?= htmlspecialchars($eleitor['nome_completo']); ?></td>
                        <td><?= htmlspecialchars($eleitor['email']); ?></td>
                        <td><?= date('d/m/Y H:i', strtotime($eleitor['data_cadastro'])); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="btn-pdf-container">
    <button id="generate-pdf" class="btn-pdf"><i class="fas fa-file-pdf"></i> Gerar Relatório em PDF</button>
</div>

<script>
    // Gráfico por Sexo
    new Chart(document.getElementById('sexoChart'), {
        type: 'doughnut',
        data: {
            labels: <?= json_encode(array_keys($dados['porSexo'])); ?>,
            datasets: [{ data: <?= json_encode(array_values($dados['porSexo'])); ?>, backgroundColor: ['#36A2EB', '#FF6384', '#FFCE56'] }]
        },
        options: { responsive: true, maintainAspectRatio: false }
    });

    // Gráfico por Tipo (Apoiador/Liderança)
    new Chart(document.getElementById('tipoChart'), {
        type: 'pie',
        data: {
            labels: <?= json_encode(array_keys($dados['porTipo'])); ?>,
            datasets: [{ data: <?= json_encode(array_values($dados['porTipo'])); ?>, backgroundColor: ['#4BC0C0', '#9966FF'] }]
        },
        options: { responsive: true, maintainAspectRatio: false }
    });

    // Gráfico por Bairro
    new Chart(document.getElementById('bairroChart'), {
        type: 'bar',
        data: {
            labels: <?= json_encode(array_keys($dados['porBairro'])); ?>,
            datasets: [{ label: 'Eleitores', data: <?= json_encode(array_values($dados['porBairro'])); ?>, backgroundColor: '#3498db' }]
        },
        options: { responsive: true, maintainAspectRatio: false, scales: { y: { beginAtZero: true, ticks: { precision: 0 } } } }
    });
    
    // Gráfico por Demanda
    new Chart(document.getElementById('demandaChart'), {
        type: 'bar',
        data: {
            labels: <?= json_encode(array_keys($dados['porDemanda'])); ?>,
            datasets: [{ label: 'Quantidade', data: <?= json_encode(array_values($dados['porDemanda'])); ?>, backgroundColor: '#2ecc71' }]
        },
        options: { responsive: true, maintainAspectRatio: false, scales: { y: { beginAtZero: true, ticks: { precision: 0 } } } }
    });

    // Função para Gerar PDF
    document.getElementById('generate-pdf').addEventListener('click', function () {
        this.textContent = 'Gerando...';
        this.disabled = true;
        const { jsPDF } = window.jspdf;
        const reportContainer = document.getElementById('report-container');
        
        html2canvas(reportContainer, { scale: 2 }).then(canvas => {
            const imgData = canvas.toDataURL('image/png');
            const doc = new jsPDF('p', 'mm', 'a4');
            const imgWidth = 210;
            const pageHeight = 297;
            const imgHeight = canvas.height * imgWidth / canvas.width;
            let heightLeft = imgHeight;
            let position = 0;

            doc.addImage(imgData, 'PNG', 0, position, imgWidth, imgHeight);
            heightLeft -= pageHeight;

            while (heightLeft >= 0) {
                position = heightLeft - imgHeight;
                doc.addPage();
                doc.addImage(imgData, 'PNG', 0, position, imgWidth, imgHeight);
                heightLeft -= pageHeight;
            }
            doc.save('relatorio-gabinete.pdf');
            this.textContent = 'Gerar Relatório em PDF';
            this.disabled = false;
        });
    });
</script>