<?php
session_start();
require_once 'src/config/config.php';
require_once 'src/models/Usuario.php';

echo "<h2>Teste de Login Programático</h2>";

// Teste 1: Verificar conexão com banco
echo "<h3>1. Teste de Conexão com Banco</h3>";
try {
    $pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
    echo "✅ Conexão com banco OK<br>";
} catch (Exception $e) {
    echo "❌ Erro na conexão: " . $e->getMessage() . "<br>";
    exit;
}

// Teste 2: Verificar usuário no banco
echo "<h3>2. Verificar Usuário no Banco</h3>";
$stmt = $pdo->prepare("SELECT * FROM usuarios WHERE email = :email AND ativo = 1");
$stmt->execute(['email' => 'admin@gabinete.com']);
$usuario = $stmt->fetch(PDO::FETCH_ASSOC);

if ($usuario) {
    echo "✅ Usuário encontrado:<br>";
    echo "ID: " . $usuario['id'] . "<br>";
    echo "Nome: " . $usuario['nome'] . "<br>";
    echo "Email: " . $usuario['email'] . "<br>";
    echo "Hash da senha: " . substr($usuario['senha'], 0, 20) . "...<br>";
} else {
    echo "❌ Usuário não encontrado<br>";
    exit;
}

// Teste 3: Verificar senha
echo "<h3>3. Teste de Verificação de Senha</h3>";
$senhaDigitada = 'admin123';
if (password_verify($senhaDigitada, $usuario['senha'])) {
    echo "✅ Senha correta<br>";
} else {
    echo "❌ Senha incorreta<br>";
    echo "Tentando outras senhas comuns...<br>";
    $senhasComuns = ['admin', '123456', 'password', 'admin@123'];
    foreach ($senhasComuns as $senha) {
        if (password_verify($senha, $usuario['senha'])) {
            echo "✅ Senha correta encontrada: " . $senha . "<br>";
            $senhaDigitada = $senha;
            break;
        }
    }
}

// Teste 4: Simular login
echo "<h3>4. Simulando Login</h3>";
if (password_verify($senhaDigitada, $usuario['senha'])) {
    $_SESSION['logado'] = true;
    $_SESSION['usuario_id'] = $usuario['id'];
    $_SESSION['usuario_nome'] = $usuario['nome'];
    $_SESSION['usuario_email'] = $usuario['email'];
    $_SESSION['usuario_nivel_acesso'] = $usuario['nivel_acesso'];
    
    echo "✅ Login simulado com sucesso<br>";
    echo "<p><a href='/gabinete/agendas'>Testar link para Agendas</a></p>";
    echo "<p><a href='/gabinete/documentos'>Testar link para Documentos</a></p>";
    echo "<p><a href='/gabinete/eleitores'>Testar link para Eleitores</a></p>";
} else {
    echo "❌ Não foi possível fazer login<br>";
}

echo "<h3>5. Status da Sessão Atual</h3>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";
?>