<?php
// debug_session.php
// Script para diagnosticar sessão e banco de dados

error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

require_once __DIR__ . '/src/config/db.php';

echo "<h1>Diagnóstico de Sessão e Acesso</h1>";

echo "<h2>1. Variáveis de Sessão Atuais</h2>";
echo "<pre>" . print_r($_SESSION, true) . "</pre>";

echo "<h2>2. Dados no Banco de Dados (para o usuário logado)</h2>";

if (empty($_SESSION['user_id'])) {
    echo "<p style='color:red'>Usuário não está logado na sessão.</p>";

    // Tenta buscar pelo email admin se não estiver logado
    $email = 'admin@gabinete.com';
    echo "<p>Buscando dados brutos para: <strong>$email</strong></p>";
    $stmt = $pdo->prepare("SELECT id, nome, email, nivelacesso, ativo FROM usuarios WHERE email = ?");
    $stmt->execute([$email]);
} else {
    $stmt = $pdo->prepare("SELECT id, nome, email, nivelacesso, ativo FROM usuarios WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
}

$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user) {
    echo "<pre>" . print_r($user, true) . "</pre>";

    echo "<h2>3. Análise</h2>";
    $nivel_sessao = $_SESSION['nivel_acesso'] ?? 'NÃO DEFINIDO';
    $nivel_banco = $user['nivelacesso'];

    echo "<ul>";
    echo "<li>Nível na Sessão: <strong>$nivel_sessao</strong></li>";
    echo "<li>Nível no Banco: <strong>$nivel_banco</strong></li>";
    echo "</ul>";

    if ($nivel_sessao !== $nivel_banco) {
        echo "<p style='color:orange'><strong>ALERTA:</strong> O nível na sessão é diferente do banco. Você precisa fazer <strong>Logout</strong> e entrar novamente para atualizar.</p>";
    } else {
        echo "<p style='color:green'>Sessão e Banco estão sincronizados.</p>";
    }

    // Teste da função nivelParaModulos (simulação)
    echo "<h2>4. Teste de Lógica (Simulação)</h2>";
    $nivel_teste = $nivel_sessao;

    // Copiando a lógica do dashboard para testar aqui
    $modulos = [];
    if (stripos($nivel_teste, 'Admin') !== false || stripos($nivel_teste, 'AcessoTotal') !== false) {
        $modulos = ['TODOS (Admin/AcessoTotal)'];
    } elseif (stripos($nivel_teste, 'AgendaFinanceiroDocumentos') !== false) {
        $modulos = ['agendas', 'contas', 'documentos'];
    } else {
        $modulos = ['NENHUM (Caiu no else)'];
    }

    echo "Para o nível '<strong>$nivel_teste</strong>', o sistema detectaria: <pre>" . print_r($modulos, true) . "</pre>";

} else {
    echo "<p style='color:red'>Usuário não encontrado no banco de dados.</p>";
}
?>