<?php

header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/src/config/db.php';

// Se não for POST, redireciona para o formulário de cadastro
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    $redirectUrl = defined('BASE_URL') ? BASE_URL . '/src/views/eleitores/cadastrar.php' : '/src/views/eleitores/cadastrar.php';
    header('Location: ' . $redirectUrl);
    exit;
}

try {
    // Obter dados do formulário
    $nomecompleto = $_POST['nome_completo'] ?? '';
    $cpf = $_POST['cpf'] ?? '';
    $datanascimento = $_POST['datanascimento'] ?? '';
    $sexo = $_POST['sexo'] ?? '';
    $telefone = $_POST['telefone'] ?? '';
    $email = $_POST['email'] ?? '';
    $endereco = $_POST['endereco'] ?? '';
    $bairro = $_POST['bairro'] ?? '';
    $cidade = $_POST['cidade'] ?? '';
    $uf = $_POST['uf'] ?? '';
    $cep = $_POST['cep'] ?? '';
    $tipo = $_POST['tipo'] ?? '';
    $demanda = $_POST['demanda'] ?? '';
    // Se demanda for array (como no form cadastrar.php: name="demanda[categoria]"), precisamos tratar
    if (is_array($demanda)) {
        // Concatena ou pega só o título? O form tem demanda[categoria], demanda[titulo], demanda[descricao]
        // Mas o código original esperava uma string simples ou não tratava array.
        // Vamos ajustar para capturar os campos corretos se vierem via POST individualmente ou array
        // O form cadastrar.php envia: demanda[categoria], demanda[titulo], demanda[descricao]
        // O código original INSERT INTO eleitores (demanda) sugere que o banco tem uma coluna 'demanda'.
        // Vamos serializar ou formatar string se for array.
        $demandaStr = '';
        if (!empty($demanda['categoria']))
            $demandaStr .= "Categoria: " . $demanda['categoria'] . ". ";
        if (!empty($demanda['titulo']))
            $demandaStr .= "Título: " . $demanda['titulo'] . ". ";
        if (!empty($demanda['descricao']))
            $demandaStr .= "Descrição: " . $demanda['descricao'];
        $demanda = $demandaStr;
    }

    $observacao = $_POST['observacao'] ?? '';

    // Validar campo obrigatório
    if (empty($nomecompleto)) {
        throw new Exception('Nome completo é obrigatório');
    }

    if (!isset($pdo)) {
        throw new Exception('Erro ao conectar com o banco de dados (PDO não iniciado).');
    }

    // Preparar e executar inserção com nomes corretos das colunas
    $sql = "INSERT INTO eleitores (nomecompleto, cpf, datanascimento, sexo, telefone, email, endereco, bairro, cidade, uf, cep, tipo, demanda, observacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $pdo->prepare($sql);

    // Converter datas vazias para NULL se necessário, ou manter string vazia dependendo do banco.
    // Assumindo que o banco aceita string vazia ou o campo é VARCHAR. Se for DATE, '' pode dar erro.
    if ($datanascimento === '')
        $datanascimento = null;

    $stmt->execute([
        $nomecompleto,
        $cpf,
        $datanascimento,
        $sexo,
        $telefone,
        $email,
        $endereco,
        $bairro,
        $cidade,
        $uf,
        $cep,
        $tipo,
        $demanda,
        $observacao
    ]);

    $lastId = $pdo->lastInsertId();

    // Retornar sucesso
    echo json_encode([
        'success' => true,
        'message' => 'Eleitor cadastrado com sucesso!',
        'id' => $lastId
    ]);

    // Redirecionar para lista após 1 segundo
    // Usa BASE_URL definida em config/env.php (carregado via db.php)
    $redirectUrl = defined('BASE_URL') ? BASE_URL . '/src/views/eleitores/lista.php' : '/src/views/eleitores/lista.php';
    header('Refresh: 1; url=' . $redirectUrl);
    exit;

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
    exit;
}

?>