-- Script SQL para atualizar coluna demanda nos registros existentes de eleitores
-- Execute este script APÓS executar o script adicionar_coluna_demanda.sql

USE gabinete_bd;

-- Atualizar coluna demanda com base nas demandas existentes na tabela demandas
-- Para cada eleitor, pegar a categoria da demanda mais recente
UPDATE eleitores e
SET demanda = (
    SELECT d.categoria 
    FROM demandas d 
    WHERE d.id_eleitor = e.id 
    ORDER BY d.data_abertura DESC 
    LIMIT 1
)
WHERE EXISTS (
    SELECT 1 
    FROM demandas d 
    WHERE d.id_eleitor = e.id
);

-- Verificar quantos registros foram atualizados
SELECT 
    COUNT(*) as 'Total de Eleitores com Demanda Atualizada'
FROM eleitores 
WHERE demanda IS NOT NULL;

-- Mostrar eleitores com suas demandas atualizadas
SELECT 
    e.id,
    e.nome_completo,
    e.telefone,
    e.bairro,
    e.tipo,
    e.demanda as categoria_demanda_principal,
    COUNT(d.id) as total_demandas
FROM eleitores e
LEFT JOIN demandas d ON e.id = d.id_eleitor
WHERE e.demanda IS NOT NULL
GROUP BY e.id, e.nome_completo, e.telefone, e.bairro, e.tipo, e.demanda
ORDER BY e.nome_completo;

-- Mostrar estatísticas por categoria de demanda
SELECT 
    demanda as categoria,
    COUNT(*) as quantidade_eleitores
FROM eleitores 
WHERE demanda IS NOT NULL
GROUP BY demanda
ORDER BY quantidade_eleitores DESC;