-- Script rápido para corrigir tabela documentos
USE gabinete;

-- Adicionar apenas a coluna tipo_midia que está causando o erro
ALTER TABLE documentos ADD COLUMN tipo_midia ENUM('imagem', 'video', 'audio', 'documento') DEFAULT 'documento';

-- Atualizar registros existentes
UPDATE documentos SET tipo_midia = 'imagem' WHERE tipo_arquivo LIKE 'image/%';
UPDATE documentos SET tipo_midia = 'video' WHERE tipo_arquivo LIKE 'video/%';
UPDATE documentos SET tipo_midia = 'audio' WHERE tipo_arquivo LIKE 'audio/%';

SELECT 'Coluna tipo_midia adicionada com sucesso!' as status;
SELECT COUNT(*) as total_documentos, tipo_midia FROM documentos GROUP BY tipo_midia;