<?php
require_once __DIR__ . '/../models/Documento.php';
require_once __DIR__ . '/../helpers/AuthHelper.php';

/**
 * Controller da área Administrativa.
 * A sua função é carregar o painel de gestão de documentos e processar uploads.
 */
class AdminController {

    /**
     * Exibe o painel de gestão de documentos.
     * Esta é a função que carrega a view correta.
     */
    public function dashboard() {
        // Garante que apenas utilizadores logados acedam
        AuthHelper::check();

        // Cria uma instância do model de Documento
        $documentoModel = new Documento();

        // Pega o filtro de categoria da URL, se houver
        $categoria_filtro = $_GET['categoria'] ?? null;

        // Busca os documentos no banco de dados
        $documentos = $documentoModel->find($categoria_filtro);

        // Define o título da página para o cabeçalho
        $pageTitle = "Gestão de Documentos";

        // Carrega as partes da página na ordem correta
        require_once __DIR__ . '/../views/partials/header.php';
        require_once __DIR__ . '/../views/admin/dashboard.php'; // Carrega a sua view
        require_once __DIR__ . '/../views/partials/footer.php';
    }

    /**
     * Processa o upload de um novo documento.
     */
    public function upload() {
        AuthHelper::check();
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['arquivo'])) {
            $titulo = $_POST['titulo'];
            $categoria = $_POST['categoria'];
            $arquivo = $_FILES['arquivo'];

            if ($arquivo['error'] !== UPLOAD_ERR_OK) {
                $_SESSION['upload_error'] = "Erro no upload do ficheiro.";
                header('Location: ' . BASE_URL . '/admin/dashboard');
                exit();
            }

            $uploadDir = 'uploads/documentos/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            $nomeArquivo = uniqid() . '-' . basename($arquivo['name']);
            $caminhoArquivo = $uploadDir . $nomeArquivo;

            if (move_uploaded_file($arquivo['tmp_name'], $caminhoArquivo)) {
                $documentoModel = new Documento();
                $dados = [
                    'id_usuario' => $_SESSION['usuario_id'],
                    'titulo' => $titulo,
                    'nome_arquivo' => $nomeArquivo,
                    'caminho_arquivo' => $caminhoArquivo,
                    'tipo_arquivo' => $arquivo['type'],
                    'tamanho_arquivo' => $arquivo['size'],
                    'categoria' => $categoria
                ];
                
                if ($documentoModel->create($dados)) {
                     $_SESSION['upload_success'] = "Documento enviado com sucesso!";
                } else {
                     $_SESSION['upload_error'] = "Erro ao salvar informações no banco de dados.";
                }

            } else {
                $_SESSION['upload_error'] = "Erro ao mover o ficheiro enviado.";
            }
        }
        
        header('Location: ' . BASE_URL . '/admin/dashboard');
        exit();
    }

    /**
     * Método index, caso alguém aceda a /admin.
     */
    public function index() {
        $this->dashboard();
    }
}
