<?php
require_once __DIR__ . '/../helpers/AuthHelper.php';
require_once __DIR__ . '/../helpers/PermissionHelper.php';

/**
 * Controller do Dashboard - Página inicial personalizada
 * Exibe uma página inicial com módulos baseados nas permissões do usuário
 */
class DashboardController {

    /**
     * Página inicial do sistema após login
     * Mostra apenas os módulos que o usuário tem permissão para acessar
     */
    public function index() {
        // Verifica se o usuário está logado
        if (!AuthHelper::check()) {
            header('Location: ' . BASE_URL . '/usuario/login');
            exit();
        }
        
        // Define o título da página
        $pageTitle = "Dashboard - Sistema de Gabinete";
        
        // Obtém informações do usuário logado
        $usuario_nome = $_SESSION['usuario_nome'] ?? 'Usuário';
        $usuario_nivel = $_SESSION['nivel_acesso'] ?? 'Sem nível';
        
        // Define se o usuário é administrador
        $is_admin = in_array($_SESSION['nivel_acesso'], ['Admin', 'Acesso_Total']);
        
        // Define módulos baseados no nível de acesso específico
        $modulos_permitidos = [];
        
        // Debug: adicionar log para verificar o nível de acesso
        error_log("Dashboard - Nível de acesso do usuário: " . ($_SESSION['nivel_acesso'] ?? 'não definido'));
        
        switch ($_SESSION['nivel_acesso']) {
            case 'Admin':
            case 'Acesso_Total':
                $modulos_permitidos = [
                    'agenda' => [
                        'nome' => 'Agenda',
                        'icone' => 'fa-calendar-alt',
                        'url' => '/',
                        'descricao' => 'Gerencie compromissos e eventos',
                        'cor' => 'bg-blue-500'
                    ],
                    'documentos' => [
                        'nome' => 'Documentos',
                        'icone' => 'fa-file-alt',
                        'url' => '/documentos',
                        'descricao' => 'Arquivo de documentos e multimídia',
                        'cor' => 'bg-green-500'
                    ],
                    'eleitores' => [
                        'nome' => 'Eleitores',
                        'icone' => 'fa-users',
                        'url' => '/eleitores',
                        'descricao' => 'Cadastro de apoiadores e lideranças',
                        'cor' => 'bg-purple-500'
                    ],
                    'rh' => [
                        'nome' => 'Recursos Humanos',
                        'icone' => 'fa-id-badge',
                        'url' => '/employees',
                        'descricao' => 'Gestão de colaboradores e RH',
                        'cor' => 'bg-orange-500'
                    ],
                    'financeiro' => [
                        'nome' => 'Financeiro',
                        'icone' => 'fa-coins',
                        'url' => '/contas/contas.php',
                        'descricao' => 'Controle financeiro e contas',
                        'cor' => 'bg-yellow-500'
                    ],
                    'admin' => [
                        'nome' => 'Administração',
                        'icone' => 'fa-user-shield',
                        'url' => '/paineladmin',
                        'descricao' => 'Painel administrativo do sistema',
                        'cor' => 'bg-red-500'
                    ],
                    'configuracoes' => [
                        'nome' => 'Configurações',
                        'icone' => 'fa-cog',
                        'url' => '/configuracoes',
                        'descricao' => 'Configurações do sistema',
                        'cor' => 'bg-gray-500'
                    ]
                ];
                break;
                
            case 'Agenda_Financeiro_Documentos':
                $modulos_permitidos = [
                    'agenda' => [
                        'nome' => 'Agenda',
                        'icone' => 'fa-calendar-alt',
                        'url' => '/',
                        'descricao' => 'Gerencie compromissos e eventos',
                        'cor' => 'bg-blue-500'
                    ],
                    'documentos' => [
                        'nome' => 'Documentos',
                        'icone' => 'fa-file-alt',
                        'url' => '/documentos',
                        'descricao' => 'Arquivo de documentos e multimídia',
                        'cor' => 'bg-green-500'
                    ],
                    'financeiro' => [
                        'nome' => 'Financeiro',
                        'icone' => 'fa-coins',
                        'url' => '/contas/contas.php',
                        'descricao' => 'Controle financeiro e contas',
                        'cor' => 'bg-yellow-500'
                    ]
                ];
                break;
                
            case 'Eleitor_Documentos':
                $modulos_permitidos = [
                    'eleitores' => [
                        'nome' => 'Eleitores',
                        'icone' => 'fa-users',
                        'url' => '/eleitores',
                        'descricao' => 'Cadastro de apoiadores e lideranças',
                        'cor' => 'bg-purple-500'
                    ],
                    'documentos' => [
                        'nome' => 'Documentos',
                        'icone' => 'fa-file-alt',
                        'url' => '/documentos',
                        'descricao' => 'Arquivo de documentos e multimídia',
                        'cor' => 'bg-green-500'
                    ]
                ];
                break;
                
            case 'Documentos_Financeiro_RH':
                $modulos_permitidos = [
                    'documentos' => [
                        'nome' => 'Documentos',
                        'icone' => 'fa-file-alt',
                        'url' => '/documentos',
                        'descricao' => 'Arquivo de documentos e multimídia',
                        'cor' => 'bg-green-500'
                    ],
                    'financeiro' => [
                        'nome' => 'Financeiro',
                        'icone' => 'fa-coins',
                        'url' => '/contas/contas.php',
                        'descricao' => 'Controle financeiro e contas',
                        'cor' => 'bg-yellow-500'
                    ],
                    'rh' => [
                        'nome' => 'Recursos Humanos',
                        'icone' => 'fa-id-badge',
                        'url' => '/employees',
                        'descricao' => 'Gestão de colaboradores e RH',
                        'cor' => 'bg-orange-500'
                    ]
                ];
                break;
                
            default:
                $modulos_permitidos = [];
                break;
        }
        
        // Carrega a view
        require_once __DIR__ . '/../views/partials/header.php';
        require_once __DIR__ . '/../views/dashboard/index.php';
        require_once __DIR__ . '/../views/partials/footer.php';
    }
}