<?php
/**
 * Funções auxiliares para autenticação
 */

// Verifica se o usuário está autenticado
function check_auth() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    
    // Verifica se o usuário está logado
    if (!isset($_SESSION['user_id']) && !isset($_SESSION['usuario_id'])) {
        header('Location: ' . BASE_URL . '/login.php');
        exit;
    }
    
    return true;
}

// Função para verificar se o usuário está logado
function is_logged_in() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    
    return !empty($_SESSION['user_id']) || !empty($_SESSION['usuario_id']);
}

// Função para redirecionar se não estiver logado
function require_login() {
    if (!is_logged_in()) {
        header('Location: ' . BASE_URL . '/login.php');
        exit;
    }
    
    return true;
}