<?php
// Proteção da sessão
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['user_id'])) {
    header("Location: /gabinete/login.php");
    exit;
}

// Incluir configurações e modelo
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../models/Eleitor.php';

// Verificar se o ID foi fornecido
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "<div class='alert alert-danger'>ID do eleitor não fornecido!</div>";
    exit;
}

$id = $_GET['id'];

// Buscar o eleitor usando o Model
try {
    $eleitorModel = new Eleitor();
    $eleitor = $eleitorModel->findById($id);

    if (!$eleitor) {
        echo "<div class='alert alert-danger'>Eleitor não encontrado!</div>";
        exit;
    }
} catch (Exception $e) {
    echo "<div class='alert alert-danger'>Erro ao buscar eleitor: " . $e->getMessage() . "</div>";
    exit;
}

$bairros = require __DIR__ . '/../../../src/config/bairros.php';
$nome = $_SESSION['nome'] ?? 'Usuário';
?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Eleitor - Gabinete</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #88589dff;
            --secondary-color: #88589dff;
            --accent-color: #3b82f6;
            --hover-color: #2563eb;
        }

        body {
            background: var(--primary-color);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding-bottom: 40px;
        }

        .navbar-custom {
            background: linear-gradient(135deg, #070849ff, #070849ff) !important;
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .content-container {
            background: white;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
            margin: 20px auto;
            max-width: 900px;
            padding: 30px;
        }

        .section-title {
            color: #2c3e50;
            font-weight: 600;
            font-size: 1.2rem;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #f0f0f0;
            display: flex;
            align-items: center;
        }

        .section-title i {
            margin-right: 10px;
            color: var(--accent-color);
        }

        .form-label {
            font-weight: 500;
            color: #555;
        }

        .btn-primary {
            background-color: #28a745;
            border: none;
            padding: 10px 25px;
            font-weight: 500;
        }

        .btn-primary:hover {
            background-color: #218838;
        }

        .btn-secondary {
            background-color: #6c757d;
            border: none;
            padding: 10px 20px;
        }

        .btn-secondary:hover {
            background-color: #5a6268;
        }
    </style>
</head>

<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark navbar-custom">
        <div class="container-fluid">
            <span class="navbar-brand">
                <i class="bi bi-people-fill me-2"></i>
                Eleitores & Cadastros
            </span>
            <div class="d-flex align-items-center text-white">
                <span class="me-3">Olá, <?= htmlspecialchars($nome) ?></span>
                <a href="<?= BASE_URL ?>/src/views/dashboard/" class="btn btn-outline-light btn-sm">
                    <i class="bi bi-house-fill me-1"></i>Painel
                </a>
            </div>
        </div>
    </nav>

    <div class="container-fluid py-4">
        <div class="content-container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0" style="color: #2c3e50; font-weight: 600;">
                    <i class="bi bi-pencil-square me-2"></i>Editar Eleitor
                </h1>
                <a href="<?= BASE_URL ?>/src/views/eleitores/lista.php" class="btn btn-outline-secondary btn-sm">
                    <i class="bi bi-arrow-left me-1"></i>Voltar
                </a>
            </div>

            <?php if (isset($_SESSION['error'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?= $_SESSION['error'];
                    unset($_SESSION['error']); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <form action="<?= BASE_URL ?>/index.php?url=eleitores/update&id=<?= $eleitor['id'] ?>" method="POST">

                <!-- Dados Pessoais -->
                <div class="section-title mt-4">
                    <i class="bi bi-person-lines-fill"></i> Dados Pessoais
                </div>

                <div class="row g-3">
                    <div class="col-md-8">
                        <label for="nome_completo" class="form-label">Nome Completo</label>
                        <input type="text" class="form-control" id="nome_completo" name="nome_completo"
                            value="<?= htmlspecialchars($eleitor['nome_completo']) ?>" required>
                    </div>
                    <div class="col-md-4">
                        <label for="cpf" class="form-label">CPF</label>
                        <input type="text" class="form-control" id="cpf" name="cpf"
                            value="<?= htmlspecialchars($eleitor['cpf'] ?? '') ?>" placeholder="000.000.000-00">
                    </div>
                    <div class="col-md-4">
                        <label for="data_nascimento" class="form-label">Data de Nascimento</label>
                        <input type="date" class="form-control" id="data_nascimento" name="data_nascimento"
                            value="<?= $eleitor['data_nascimento'] ?>">
                    </div>
                    <div class="col-md-4">
                        <label for="telefone" class="form-label">Telefone</label>
                        <input type="text" class="form-control" id="telefone" name="telefone"
                            value="<?= htmlspecialchars($eleitor['telefone'] ?? '') ?>">
                    </div>
                    <div class="col-md-4">
                        <label for="email" class="form-label">E-mail</label>
                        <input type="email" class="form-control" id="email" name="email"
                            value="<?= htmlspecialchars($eleitor['email'] ?? '') ?>">
                    </div>
                </div>

                <!-- Endereço -->
                <div class="section-title mt-5">
                    <i class="bi bi-geo-alt-fill"></i> Endereço
                </div>

                <div class="row g-3">
                    <div class="col-12">
                        <label for="endereco" class="form-label">Endereço Completo</label>
                        <input type="text" class="form-control" id="endereco" name="endereco"
                            value="<?= htmlspecialchars($eleitor['endereco'] ?? '') ?>">
                    </div>
                    <div class="col-md-5">
                        <label for="bairro" class="form-label">Bairro</label>
                        <input class="form-control" list="lista-bairros" id="bairro" name="bairro"
                            value="<?= htmlspecialchars($eleitor['bairro'] ?? '') ?>"
                            placeholder="Digite para buscar...">
                        <datalist id="lista-bairros">
                            <?php foreach ($bairros as $b): ?>
                                <option value="<?= htmlspecialchars($b) ?>">
                                <?php endforeach; ?>
                        </datalist>
                    </div>
                    <div class="col-md-4">
                        <label for="cidade" class="form-label">Cidade</label>
                        <input type="text" class="form-control" id="cidade" name="cidade"
                            value="<?= htmlspecialchars($eleitor['cidade'] ?? 'Belém') ?>">
                    </div>
                    <div class="col-md-1">
                        <label for="uf" class="form-label">UF</label>
                        <input type="text" class="form-control" id="uf" name="uf"
                            value="<?= htmlspecialchars($eleitor['uf'] ?? 'PA') ?>" maxlength="2">
                    </div>
                    <div class="col-md-2">
                        <label for="cep" class="form-label">CEP</label>
                        <input type="text" class="form-control" id="cep" name="cep"
                            value="<?= htmlspecialchars($eleitor['cep'] ?? '') ?>">
                    </div>
                </div>

                <!-- Outras Informações -->
                <div class="section-title mt-5">
                    <i class="bi bi-info-circle-fill"></i> Outras Informações
                </div>

                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="sexo" class="form-label">Sexo</label>
                        <select class="form-select" id="sexo" name="sexo">
                            <option value="">Selecione...</option>
                            <option value="Masculino" <?= ($eleitor['sexo'] ?? '') === 'Masculino' ? 'selected' : '' ?>>
                                Masculino</option>
                            <option value="Feminino" <?= ($eleitor['sexo'] ?? '') === 'Feminino' ? 'selected' : '' ?>>
                                Feminino</option>
                            <option value="Outro" <?= ($eleitor['sexo'] ?? '') === 'Outro' ? 'selected' : '' ?>>Outro
                            </option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="tipo" class="form-label">Tipo de Cadastro</label>
                        <select class="form-select" id="tipo" name="tipo" required>
                            <option value="Apoiador" <?= ($eleitor['tipo'] ?? '') === 'Apoiador' ? 'selected' : '' ?>>
                                Apoiador</option>
                            <option value="Liderança" <?= ($eleitor['tipo'] ?? '') === 'Liderança' ? 'selected' : '' ?>>
                                Liderança</option>
                        </select>
                    </div>
                    <div class="col-12">
                        <label for="demanda" class="form-label">Demanda Inicial</label>
                        <textarea class="form-control" id="demanda" name="demanda"
                            rows="3"><?= htmlspecialchars($eleitor['demanda'] ?? '') ?></textarea>
                    </div>
                    <div class="col-12">
                        <label for="observacao" class="form-label">Observações Gerais</label>
                        <textarea class="form-control" id="observacao" name="observacao"
                            rows="4"><?= htmlspecialchars($eleitor['observacao'] ?? '') ?></textarea>
                    </div>
                </div>

                <div class="d-flex justify-content-end gap-2 mt-5">
                    <a href="<?= BASE_URL ?>/src/views/eleitores/lista.php" class="btn btn-secondary">
                        <i class="bi bi-x-lg me-1"></i>Cancelar
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-lg me-1"></i>Salvar Alterações
                    </button>
                </div>

            </form>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>