<?php
if (session_status() === PHP_SESSION_NONE)
  session_start();
$cfg = dirname(__DIR__, 2) . '/config/config.php';
if (file_exists($cfg))
  require_once $cfg;
if (!defined('BASE_URL'))
  define('BASE_URL', 'http://localhost:8888/gabinete');

// Função para escapar HTML

/* ========= Lógica para buscar dados (mantida como no seu original) ========= */
$rows = $rows ?? [];
$errMsg = $errMsg ?? null;
if (empty($rows)) {
  try {
    // Usa a conexão global $pdo definida em src/config/db.php
    require_once dirname(__DIR__, 2) . '/config/db.php';

    if (isset($pdo)) {
      $sql = "SELECT id, full_name, job_title, status FROM employees ORDER BY full_name";
      $stmt = $pdo->query($sql);
      $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
  } catch (Throwable $e) {
    $errMsg = 'Erro ao listar colaboradores: ' . $e->getMessage();
  }
}

// A função `e()` para escapar HTML é uma ótima prática.
function e(?string $v): string
{
  return htmlspecialchars((string) $v, ENT_QUOTES, 'UTF-8');
}

require_once dirname(__DIR__, 1) . '/partials/header.php';
?>

<style>
  .modern-colab-container {
    max-width: 900px;
    margin: 32px auto;
    padding: 24px 16px;
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 2px 16px rgba(44, 62, 80, 0.07);
  }

  .modern-colab-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 24px;
    flex-wrap: wrap;
    gap: 16px;
  }

  .modern-colab-header h1 {
    font-size: 2rem;
    font-weight: 700;
    color: #2c3e50;
    margin: 0;
    letter-spacing: 0.01em;
  }

  .modern-colab-header .btn-primary {
    background-color: #3498db;
    border-color: #3498db;
    padding: 10px 24px;
    font-weight: 500;
    text-decoration: none;
    color: #fff;
    border-radius: 8px;
    box-shadow: 0 2px 8px rgba(44, 62, 80, 0.07);
    transition: background-color 0.2s;
  }

  .modern-colab-header .btn-primary:hover {
    background-color: #2980b9;
  }

  .modern-colab-table {
    width: 100%;
    border-collapse: collapse;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 4px 16px rgba(44, 62, 80, 0.1);
    background: #fff;
  }

  .modern-colab-table th,
  .modern-colab-table td {
    padding: 18px 14px;
    text-align: left;
    border-bottom: 1px solid #f0f0f0;
  }

  .modern-colab-table th {
    background: #f7f9fa;
    color: #34495e;
    font-weight: 600;
  }

  .modern-colab-table tbody tr:hover {
    background: #f9f9f9;
  }

  .modern-colab-actions a {
    text-decoration: none;
    padding: 6px 14px;
    border-radius: 6px;
    margin-right: 8px;
    font-size: 0.97em;
    background: #f7f9fa;
    color: #2c3e50;
    border: 1px solid #dbe2ea;
    transition: background 0.2s, color 0.2s;
  }

  .modern-colab-actions a:hover {
    background: #2c3e50;
    color: #fff;
  }
</style>

<div class="modern-colab-container">
  <div class="modern-colab-header">
    <div style="display:flex;align-items:center;gap:12px;">
      <a href="<?= BASE_URL ?>/rh" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Voltar
      </a>
      <h1 style="margin:0;">Colaboradores</h1>
    </div>
    <a href="<?= BASE_URL ?>/employees/create" class="btn btn-primary">Novo Colaborador</a>
  </div>

  <?php if ($errMsg): ?>
    <div class="alert alert-danger"><?= e($errMsg) ?></div>
  <?php endif; ?>

  <?php if (!empty($rows)): ?>
    <div class="table-responsive">
      <table class="modern-colab-table">
        <thead>
          <tr>
            <th>Nome</th>
            <th>Cargo</th>
            <th>Status</th>
            <th>Ações</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $row): ?>
            <tr>
              <td><?= e($row['full_name']) ?></td>
              <td><?= e($row['job_title']) ?></td>
              <td><?= e($row['status']) ?></td>
              <td class="modern-colab-actions">
                <a href="<?= BASE_URL ?>/employees/<?= $row['id'] ?>" class="btn btn-sm btn-info">Ver</a>
                <a href="<?= BASE_URL ?>/employees/edit/<?= $row['id'] ?>" class="btn btn-sm btn-warning">Editar</a>
                <a href="<?= BASE_URL ?>/employees/delete/<?= $row['id'] ?>" class="btn btn-sm btn-danger"
                  onclick="return confirm('Tem certeza que deseja excluir este colaborador?');">Excluir</a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  <?php elseif (!$errMsg): ?>
    <div class="alert alert-info mt-4">Nenhum colaborador cadastrado.</div>
  <?php endif; ?>
</div>

<?php
/* ========= Carrega rodapé padrão ========= */
require_once dirname(__DIR__, 1) . '/partials/footer.php';
?>