<?php
// gabinete/src/views/employees/index.php

require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../helpers/AuthHelper.php';

// Se quiser forçar login, troque para: AuthHelper::requireLogin();
AuthHelper::check();

$pageTitle = "Colaboradores";
$nome = $_SESSION['nome'] ?? 'Usuário';
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($pageTitle) ?></title>

  <!-- Bootstrap 5 + Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body { background: #ffffffff; }
    .page-hero {
      /* Cor padrão do sistema - Ajuste conforme necessário */
      background: linear-gradient(135deg, #0B1F3A, #102B54);
      color: #fff;
      border-bottom-left-radius: 24px;
      border-bottom-right-radius: 24px;
    }
    .page-hero .title {
      font-weight: 700;
      letter-spacing: .2px;
    }
    .rh-card {
      border: 1px solid #3592efff;
      border-radius: 18px;
      box-shadow: 0 4px 16px rgba(0,0,0,.06);
      transition: transform .2s ease, box-shadow .2s ease;
    }
    .rh-card:hover {
      transform: translateY(-2px);
      box-shadow: 0 10px 24px rgba(0,0,0,.08);
    }
    .rh-card .icon-wrap {
      width: 48px; height: 48px;
      border-radius: 12px;
      display: inline-flex; align-items: center; justify-content: center;
    }
    .btn-soft {
      border-radius: 12px;
      font-weight: 600;
      padding: .6rem 1rem;
    }
  </style>
</head>
<body>

  <!-- HERO -->
  <section class="page-hero py-5">
    <div class="container">
      <div class="d-flex justify-content-between align-items-start align-items-md-center flex-column flex-md-row gap-3">
        <div class="text-white">
          <h1 class="title h2 mb-2">
            <i class="bi bi-people-fill me-2"></i><?= htmlspecialchars($pageTitle) ?>
          </h1>
          <p class="mb-0 text-white-50">Gerencie colaboradores e documentos</p>
        </div>
        <div class="d-flex gap-2">
          <a href="<?= BASE_URL ?>/" class="btn btn-light btn-soft">
            <i class="bi bi-house-door me-2"></i>Início
          </a>
          <a href="<?= BASE_URL ?>/configuracoes" class="btn btn-outline-light btn-soft">
            <i class="bi bi-gear me-2"></i>Configurações
          </a>
        </div>
      </div>
    </div>
  </section>

  <!-- CONTEÚDO -->
  <main class="container py-4 py-md-5">

    <!-- CARDS DE MÓDULOS -->
    <div class="row g-4">

      <!-- Colaboradores -->
      <div class="col-12 col-md-6 col-xl-4">
        <div class="rh-card p-4 h-100">
          <div class="d-flex align-items-center mb-3">
            <div class="icon-wrap bg-primary-subtle text-primary me-3">
              <i class="bi bi-people fs-4"></i>
            </div>
            <h5 class="mb-0">Colaboradores</h5>
          </div>
          <p class="text-muted mb-4">Cadastre, edite e acompanhe dados da sua equipe.</p>
          <a href="<?= BASE_URL ?>/src/views/employees/colaboradores.php" class="btn btn-primary btn-soft w-100">
            <i class="bi bi-arrow-right me-2"></i>Acessar
          </a>
        </div>
      </div>

      <!-- As opções de Controle de Ponto e Folha de Pagamento foram removidas conforme solicitado -->

      <!-- Documentos (opcional) -->
      <div class="col-12 col-md-6 col-xl-4">
        <div class="rh-card p-4 h-100">
          <div class="d-flex align-items-center mb-3">
            <div class="icon-wrap bg-info-subtle text-info me-3">
              <i class="bi bi-folder2-open fs-4"></i>
            </div>
            <h5 class="mb-0">Documentos</h5>
          </div>
          <p class="text-muted mb-4">Centralize contratos, exames e anexos de colaboradores.</p>
          <a href="<?= BASE_URL ?>/src/views/employees/documentos.php" class="btn btn-info btn-soft w-100 text-white">
            <i class="bi bi-arrow-right me-2"></i>Acessar
          </a>
        </div>
      </div>

      <!-- Relatórios RH (opcional) -->
      <div class="col-12 col-md-6 col-xl-4">
        <div class="rh-card p-4 h-100">
          <div class="d-flex align-items-center mb-3">
            <div class="icon-wrap bg-secondary-subtle text-secondary me-3">
              <i class="bi bi-graph-up-arrow fs-4"></i>
            </div>
            <h5 class="mb-0">Relatórios RH</h5>
          </div>
          <p class="text-muted mb-4">Indicadores, estatísticas e exportação.</p>
          <a href="<?= BASE_URL ?>/src/views/employees/relatorios.php" class="btn btn-secondary btn-soft w-100">
            <i class="bi bi-arrow-right me-2"></i>Acessar
          </a>
        </div>
      </div>

      <!-- Configurações RH (opcional) -->
      <div class="col-12 col-md-6 col-xl-4">
        <div class="rh-card p-4 h-100">
          <div class="d-flex align-items-center mb-3">
            <div class="icon-wrap bg-dark-subtle text-dark me-3">
              <i class="bi bi-sliders2-vertical fs-4"></i>
            </div>
            <h5 class="mb-0">Configurações RH</h5>
          </div>
          <p class="text-muted mb-4">Centros de custo, cargos, permissões e integrações.</p>
          <a href="<?= BASE_URL ?>/src/views/employees/configuracoes.php" class="btn btn-dark btn-soft w-100">
            <i class="bi bi-arrow-right me-2"></i>Acessar
          </a>
        </div>
      </div>

    </div>
  </main>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
