<?php
// gabinete/src/views/employees/relatorios.php

require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../helpers/AuthHelper.php';

// Se quiser forçar login, troque para: AuthHelper::requireLogin();
AuthHelper::check();

$pageTitle = "Relatórios RH";
$nome = $_SESSION['nome'] ?? 'Usuário';
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($pageTitle) ?></title>

  <!-- Bootstrap 5 + Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body { background: #f5f7fb; }
    .page-hero {
      /* Cor padrão do sistema - Ajuste conforme necessário */
      background: linear-gradient(135deg, #0B1F3A, #102B54);
      color: #fff;
      border-bottom-left-radius: 24px;
      border-bottom-right-radius: 24px;
    }
    .page-hero .title {
      font-weight: 700;
      letter-spacing: .2px;
    }
    .card {
      border-radius: 12px;
      box-shadow: 0 4px 16px rgba(0,0,0,.06);
    }
    .btn-soft {
      border-radius: 12px;
      font-weight: 600;
      padding: .6rem 1rem;
    }
    .report-card {
      transition: transform .2s ease;
    }
    .report-card:hover {
      transform: translateY(-3px);
    }
  </style>
</head>
<body>

  <!-- HERO -->
  <section class="page-hero py-5">
    <div class="container">
      <div class="d-flex justify-content-between align-items-start align-items-md-center flex-column flex-md-row gap-3">
        <div class="text-white">
          <h1 class="title h2 mb-2">
            <i class="bi bi-graph-up-arrow me-2"></i><?= htmlspecialchars($pageTitle) ?>
          </h1>
          <p class="mb-0 text-white-50">Indicadores e estatísticas de RH</p>
        </div>
        <div class="d-flex gap-2">
          <a href="<?= BASE_URL ?>/employees" class="btn btn-light btn-soft">
            <i class="bi bi-arrow-left me-2"></i>Voltar
          </a>
        </div>
      </div>
    </div>
  </section>

  <!-- CONTEÚDO -->
  <main class="container py-4 py-md-5">
    
    <!-- Filtros -->
    <div class="card mb-4">
      <div class="card-body">
        <h5 class="card-title mb-3">Filtros</h5>
        <form class="row g-3">
          <div class="col-md-4">
            <label class="form-label">Período</label>
            <select class="form-select">
              <option>Último mês</option>
              <option>Últimos 3 meses</option>
              <option>Último ano</option>
              <option>Personalizado</option>
            </select>
          </div>
          <div class="col-md-4">
            <label class="form-label">Departamento</label>
            <select class="form-select">
              <option value="">Todos</option>
              <option>TI</option>
              <option>Administrativo</option>
              <option>Financeiro</option>
            </select>
          </div>
          <div class="col-md-4">
            <label class="form-label">Tipo de Relatório</label>
            <select class="form-select">
              <option value="">Todos</option>
              <option>Headcount</option>
              <option>Turnover</option>
              <option>Absenteísmo</option>
            </select>
          </div>
          <div class="col-12">
            <button type="submit" class="btn btn-primary">Filtrar</button>
            <button type="reset" class="btn btn-outline-secondary">Limpar</button>
          </div>
        </form>
      </div>
    </div>
    
    <!-- Relatórios -->
    <div class="row g-4">
      <!-- Relatório 1 -->
      <div class="col-md-6 col-lg-4">
        <div class="card report-card h-100">
          <div class="card-body">
            <h5 class="card-title">Headcount</h5>
            <p class="card-text text-muted">Distribuição de colaboradores por departamento</p>
            <div class="text-center my-4">
              <div style="height: 150px; background-color: #f8f9fa; border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                <span class="text-muted">Gráfico de pizza</span>
              </div>
            </div>
            <div class="d-grid">
              <a href="#" class="btn btn-outline-primary">
                <i class="bi bi-download me-2"></i>Exportar
              </a>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Relatório 2 -->
      <div class="col-md-6 col-lg-4">
        <div class="card report-card h-100">
          <div class="card-body">
            <h5 class="card-title">Turnover</h5>
            <p class="card-text text-muted">Taxa de rotatividade mensal</p>
            <div class="text-center my-4">
              <div style="height: 150px; background-color: #f8f9fa; border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                <span class="text-muted">Gráfico de linha</span>
              </div>
            </div>
            <div class="d-grid">
              <a href="#" class="btn btn-outline-primary">
                <i class="bi bi-download me-2"></i>Exportar
              </a>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Relatório 3 -->
      <div class="col-md-6 col-lg-4">
        <div class="card report-card h-100">
          <div class="card-body">
            <h5 class="card-title">Absenteísmo</h5>
            <p class="card-text text-muted">Taxa de ausências por departamento</p>
            <div class="text-center my-4">
              <div style="height: 150px; background-color: #f8f9fa; border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                <span class="text-muted">Gráfico de barras</span>
              </div>
            </div>
            <div class="d-grid">
              <a href="#" class="btn btn-outline-primary">
                <i class="bi bi-download me-2"></i>Exportar
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>