<?php
// Inicia a sessão se ainda não foi iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Inclui as configurações
require_once __DIR__ . '/../../config/config.php';

// Inclui o controller de relatórios
require_once __DIR__ . '/../../controllers/RelatoriosController.php';

// Cria uma instância do controller
$controller = new RelatoriosController();

// Verifica a ação solicitada
$action = isset($_GET['action']) ? trim($_GET['action']) : 'index';

if ($action === 'porUsuario') {
    $controller->porUsuario();
} elseif ($action === 'liderancas') {
    // DEBUG: Se entrar aqui, o problema não é no index.php
    // die("DEBUG: Rota 'liderancas' encontrada no index.php!"); 
    $controller->liderancas();
} else {
    $controller->index();
}
?>