<?php
// O controller disponibiliza a variável $dados (array de arrays com 'nome' e 'quantidade')
?>
<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($pageTitle) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap"
        rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f8fafc;
        }

        .card-container {
            background-color: #ffffff;
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
            margin-top: 2rem;
        }
    </style>
</head>

<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container-fluid">
            <span class="navbar-brand">
                <i class="bi bi-bar-chart-fill me-2"></i>
                <?= htmlspecialchars($pageTitle) ?>
            </span>
            <a href="<?= BASE_URL ?>/src/views/relatorios/" class="btn btn-outline-light btn-sm">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>
    </nav>

    <div class="container py-4">
        <div class="card-container">
            <h4 class="mb-4">Cadastros por Usuário</h4>

            <?php if (empty($dados)): ?>
                <div class="alert alert-info">Nenhum registro encontrado.</div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover table-striped">
                        <thead class="table-light">
                            <tr>
                                <th>Data</th>
                                <th>Usuário</th>
                                <th class="text-end">Quantidade de Cadastros</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($dados as $row): ?>
                                <tr>
                                    <td><?= date('d/m/Y', strtotime($row['data'])) ?></td>
                                    <td><?= htmlspecialchars($row['nome']) ?></td>
                                    <td class="text-end fw-bold"><?= number_format($row['quantidade']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>

</html>