<?php
// test_db_connection.php
// Script para diagnosticar problemas de conexão com o banco de dados

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Diagnóstico de Conexão com o Banco de Dados</h1>";

// 1. Verificar carregamento do config
echo "<h2>1. Carregando Configurações</h2>";
try {
    $configFile = __DIR__ . '/src/config/config.php';
    if (!file_exists($configFile)) {
        throw new Exception("Arquivo de configuração não encontrado: $configFile");
    }
    $config = require $configFile;
    echo "<p style='color:green'>Configuração carregada com sucesso.</p>";

    // Ocultar senha na exibição
    $displayConfig = $config;
    if (isset($displayConfig['database']['password'])) {
        $displayConfig['database']['password'] = '********';
    }
    echo "<pre>" . print_r($displayConfig, true) . "</pre>";

} catch (Exception $e) {
    echo "<p style='color:red'>Erro ao carregar configuração: " . $e->getMessage() . "</p>";
    exit;
}

// 2. Testar Conexão PDO
echo "<h2>2. Testando Conexão PDO</h2>";
try {
    $dsn = "mysql:host={$config['database']['host']};port={$config['database']['port']};dbname={$config['database']['database']};charset={$config['database']['charset']}";
    echo "<p>Tentando conectar com DSN: <code>$dsn</code></p>";

    $pdo = new PDO(
        $dsn,
        $config['database']['username'],
        $config['database']['password'],
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );

    echo "<p style='color:green'><strong>SUCESSO: Conexão estabelecida!</strong></p>";

    // 3. Verificar tabelas
    echo "<h2>3. Verificando Tabelas</h2>";
    $stmt = $pdo->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);

    if (empty($tables)) {
        echo "<p style='color:orange'>Nenhuma tabela encontrada no banco de dados.</p>";
    } else {
        echo "<p>Tabelas encontradas:</p><ul>";
        foreach ($tables as $table) {
            echo "<li>$table</li>";
        }
        echo "</ul>";

        // Verificar se tabela usuarios existe
        if (in_array('usuarios', $tables)) {
            $count = $pdo->query("SELECT COUNT(*) FROM usuarios")->fetchColumn();
            echo "<p>Tabela <code>usuarios</code> tem $count registros.</p>";
        } else {
            echo "<p style='color:red'>ERRO: Tabela <code>usuarios</code> não encontrada!</p>";
        }
    }

} catch (PDOException $e) {
    echo "<p style='color:red'><strong>ERRO DE CONEXÃO:</strong> " . $e->getMessage() . "</p>";
    echo "<p>Verifique se:</p>";
    echo "<ul>";
    echo "<li>O host do banco de dados está correto (localhost vs IP).</li>";
    echo "<li>O nome do banco de dados está correto.</li>";
    echo "<li>O usuário e senha estão corretos.</li>";
    echo "<li>O usuário tem permissão de acesso a partir deste host.</li>";
    echo "</ul>";
}
?>