<?php
/**
 * Funções para conexão com o banco de dados
 */

// Função para obter uma conexão PDO com o banco de dados
function get_db_connection() {
    static $pdo = null;
    
    if ($pdo instanceof PDO) {
        return $pdo;
    }
    
    try {
        $pdo = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false
            ]
        );
        
        return $pdo;
    } catch (PDOException $e) {
        // Log do erro
        error_log("Erro na conexão com o banco de dados: " . $e->getMessage());
        
        // Lança a exceção para ser tratada pelo código que chamou esta função
        throw new PDOException("Erro na conexão com o banco de dados: " . $e->getMessage());
    }
}