<?php

require_once __DIR__ . '/../models/Usuario.php';

class PermissionHelper {
    
    public static function verificarPermissao($modulo, $acao = 'visualizar') {
        // Verificar se o usuário está logado
        if (!isset($_SESSION['usuario_id']) || !isset($_SESSION['nivel_acesso'])) {
            return false;
        }
        
        $nivelAcesso = $_SESSION['nivel_acesso'];
        
        // Admin sempre tem acesso total
        if ($nivelAcesso === 'Admin') {
            return true;
        }
        
        // Verificar permissão específica
        $usuario = new Usuario();
        return $usuario->temPermissao($nivelAcesso, $modulo, $acao);
    }
    
    public static function redirecionarSeNaoTemPermissao($modulo, $acao = 'visualizar') {
        if (!self::verificarPermissao($modulo, $acao)) {
            header('Location: ' . BASE_URL . '/acesso-negado');
            exit;
        }
    }
    
    public static function getPermissoesUsuario() {
        if (!isset($_SESSION['nivel_acesso'])) {
            return [];
        }
        
        $usuario = new Usuario();
        return $usuario->getPermissoes($_SESSION['nivel_acesso']);
    }
    
    public static function podeAcessarModulo($modulo) {
        return self::verificarPermissao($modulo, 'visualizar');
    }
    
    public static function podeCriar($modulo) {
        return self::verificarPermissao($modulo, 'criar');
    }
    
    public static function podeEditar($modulo) {
        return self::verificarPermissao($modulo, 'editar');
    }
    
    public static function podeExcluir($modulo) {
        return self::verificarPermissao($modulo, 'excluir');
    }
    
    public static function getModulosPermitidos() {
        $permissoes = self::getPermissoesUsuario();
        $modulosPermitidos = [];
        
        foreach ($permissoes as $modulo => $acoes) {
            if ($acoes['visualizar']) {
                $modulosPermitidos[] = $modulo;
            }
        }
        
        return $modulosPermitidos;
    }
    
    public static function getNomeNivelAcesso($nivel) {
        $niveis = [
            'Admin' => 'Administrador',
            'Acesso_Total' => 'Acesso Total',
            'Agenda_Financeiro_Documentos' => 'Agenda + Financeiro + Documentos',
            'Eleitor_Documentos' => 'Eleitores + Documentos',
            'Documentos_Financeiro_RH' => 'Documentos + Financeiro + RH'
        ];
        
        return isset($niveis[$nivel]) ? $niveis[$nivel] : $nivel;
    }
}