<?php

class Relatorio {
    private $pdo;

    public function __construct() {
        if (!defined('DB_HOST') || !defined('DB_USER') || !defined('DB_PASS') || !defined('DB_NAME')) {
            throw new Exception('Constantes de banco de dados não definidas');
        }
        
        try {
            $this->pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
            $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            throw new Exception("Erro na conexão com o banco de dados: " . $e->getMessage());
        }
    }

    public function getTotalEleitores() {
        try {
            $stmt = $this->pdo->query("SELECT COUNT(*) as total FROM eleitores");
            return $stmt->fetchColumn();
        } catch (PDOException $e) {
            return 0;
        }
    }

    public function getContagemPorSexo() {
        try {
            $stmt = $this->pdo->query("SELECT sexo, COUNT(*) as quantidade FROM eleitores WHERE sexo IS NOT NULL AND sexo != '' GROUP BY sexo");
            return $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
        } catch (PDOException $e) {
            return [];
        }
    }

    public function getContagemPorBairro() {
        try {
            $stmt = $this->pdo->query("SELECT bairro, COUNT(*) as quantidade FROM eleitores WHERE bairro IS NOT NULL AND bairro != '' GROUP BY bairro ORDER BY quantidade DESC LIMIT 10");
            return $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
        } catch (PDOException $e) {
            return [];
        }
    }

    public function getContagemPorTipo() {
        try {
            $stmt = $this->pdo->query("SELECT tipo, COUNT(*) as quantidade FROM eleitores GROUP BY tipo");
            return $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
        } catch (PDOException $e) {
            return [];
        }
    }

    public function getEleitoresRecentes() {
        try {
            $stmt = $this->pdo->query("SELECT nome_completo, bairro, data_cadastro, tipo FROM eleitores ORDER BY data_cadastro DESC LIMIT 5");
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            // Mapear os campos para o formato esperado pela view
            $eleitores = [];
            foreach ($result as $eleitor) {
                $eleitores[] = [
                    'nome' => $eleitor['nome_completo'] ?? 'Nome não informado',
                    'bairro' => $eleitor['bairro'] ?? 'Não informado',
                    'data_cadastro' => $eleitor['data_cadastro'] ?? date('Y-m-d H:i:s'),
                    'tipo' => $eleitor['tipo'] ?? 'Não informado'
                ];
            }
            
            return $eleitores;
        } catch (PDOException $e) {
            return [];
        }
    }

    public function getContagemPorDemanda() {
        try {
            $stmt = $this->pdo->query("SELECT categoria, COUNT(*) as quantidade FROM demandas WHERE categoria IS NOT NULL AND categoria != '' GROUP BY categoria ORDER BY quantidade DESC");
            return $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
        } catch (PDOException $e) {
            return [];
        }
    }

    public function getContagemPorDemandaEleitores() {
        try {
            $stmt = $this->pdo->query("SELECT demanda, COUNT(*) as quantidade FROM eleitores WHERE demanda IS NOT NULL AND demanda != '' GROUP BY demanda ORDER BY quantidade DESC");
            return $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
        } catch (PDOException $e) {
            return [];
        }
    }
}
