<?php
echo "<h1>Criação de Pastas para Upload</h1>";

// Criar pasta uploads
if (!is_dir('uploads')) {
    if (mkdir('uploads', 0755)) {
        echo "<p style='color:green;'>✅ Pasta 'uploads' criada com sucesso</p>";
    } else {
        echo "<p style='color:red;'>❌ Erro ao criar pasta 'uploads'</p>";
    }
} else {
    echo "<p style='color:orange;'>⚠️ Pasta 'uploads' já existe</p>";
}

// Criar pasta comprovantes
if (!is_dir('uploads/comprovantes')) {
    if (mkdir('uploads/comprovantes', 0755, true)) {
        echo "<p style='color:green;'>✅ Pasta 'uploads/comprovantes' criada com sucesso</p>";
    } else {
        echo "<p style='color:red;'>❌ Erro ao criar pasta 'uploads/comprovantes'</p>";
    }
} else {
    echo "<p style='color:orange;'>⚠️ Pasta 'uploads/comprovantes' já existe</p>";
}

// Criar arquivo .htaccess para segurança
$htaccess_content = "# Proteger pasta de uploads
Options -Indexes
<Files *.php>
    Deny from all
</Files>";

if (!file_exists('uploads/.htaccess')) {
    if (file_put_contents('uploads/.htaccess', $htaccess_content)) {
        echo "<p style='color:green;'>✅ Arquivo de segurança .htaccess criado</p>";
    }
}

// Verificar permissões
echo "<h2>Verificação de Permissões:</h2>";

if (is_dir('uploads')) {
    $perms_uploads = substr(sprintf('%o', fileperms('uploads')), -4);
    echo "<p>📁 Pasta uploads: <strong>$perms_uploads</strong></p>";
}

if (is_dir('uploads/comprovantes')) {
    $perms_comprovantes = substr(sprintf('%o', fileperms('uploads/comprovantes')), -4);
    echo "<p>📁 Pasta comprovantes: <strong>$perms_comprovantes</strong></p>";
    
    if (is_writable('uploads/comprovantes')) {
        echo "<p style='color:green;'>✅ Pasta comprovantes é <strong>GRAVÁVEL</strong></p>";
    } else {
        echo "<p style='color:red;'>❌ Pasta comprovantes <strong>NÃO É GRAVÁVEL</strong></p>";
        echo "<p>Tente alterar as permissões para 755 ou 777</p>";
    }
}

// Teste de escrita
$teste_arquivo = 'uploads/comprovantes/teste.txt';
if (file_put_contents($teste_arquivo, 'Teste de escrita')) {
    echo "<p style='color:green;'>✅ Teste de escrita: <strong>SUCESSO</strong></p>";
    unlink($teste_arquivo); // Remove o arquivo de teste
} else {
    echo "<p style='color:red;'>❌ Teste de escrita: <strong>FALHOU</strong></p>";
}

echo "<hr>";
echo "<h2>🎉 Configuração Finalizada!</h2>";
echo "<p><a href='index.php' style='background:#2980b9; color:white; padding:10px 20px; text-decoration:none; border-radius:5px;'>🚀 Acessar Dashboard</a></p>";
echo "<p><strong>IMPORTANTE:</strong> Delete este arquivo após verificar que tudo está funcionando!</p>";
?>
